require("locations/defines.lua");

novelty = "scarab"; --Scarab Novelty Shape
ingred1 = 9;        --Mint
ingred2 = 11;       --Orange
ingred3 = 10;       --Raspberry
topping1 = 4;       --Lemon
topping2 = 2;       --Cashews
topping3 = 6;       --Amaretto
infusion1 = 6;      --Yogurt
infusion2 = 9;      --Cherry
infusion3 = 10;     --Date

gaberounChocolates = {
	
	baseDir = "anim/chocolates/",
	
-- Bucket Object
	bucket = {
		baseDir = "anim/chocolates/barrel/",
		x = 0, y = 0,
		type = "barrel",
		layerType = kBucketLayer,
		barType = kNothing,
		assets = {
			default = {
				{ state="default", file="barrel" },
			},
		},
		children = {
		    icon = {
		        leaf = true,
		        visible = false,
		        anchor = "icon",
		        name = "icon",
		        assets = {
			        choc = {
				        { state="option_0",  file="barrel_icons", base=13 },
				        { state="option_1",  file="barrel_icons", base=14 },
				        { state="option_2",  file="barrel_icons", base=15 },
			        },
			        overlay= {
				        { state="option_0",  file="barrel_icons", base=ingred1 },
				        { state="option_1",  file="barrel_icons", base=ingred2 },
				        { state="option_2",  file="barrel_icons", base=ingred3 },
			        },
			    },
			},
		},
	},

----------------------------------------------------------- SHAPES
	
-- Dark Chocolate Truffle	
	truffle_shape_dark = {
		layerType = kChocolateLayer,
		barType = kTruffle,
		option = 0,
		tint = DarkChocTint,
		assets = {
			shape = {
				{ state="default", file="truffle_shape", base=0 },
			},
		},
	},
	
-- Milk Chocolate Truffle
	truffle_shape_milk = {
		layerType = kChocolateLayer,
		barType = kTruffle,
		option = 1,
		assets = {
			shape = {
				{ state="default", file="truffle_shape", base=1 },
			},
		},
	},

-- White Chocolate Truffle
	truffle_shape_white = {
		layerType = kChocolateLayer,
		barType = kTruffle,
		option = 2,
		assets = {
			shape = {
				{ state="default", file="truffle_shape", base=2 },
			},
		},
	},

-- Dark Chocolate Bar	
	bar_shape_dark = {
		layerType = kChocolateLayer,
		barType = kBar,
		option = 0,
		tint = DarkChocTint,
		assets = {
			shape = {
				{ state="default", file="bar_shape", base=0 },
			},
		},
	},
	
-- Milk Chocolate Bar
	bar_shape_milk = {
		layerType = kChocolateLayer,
		barType = kBar,
		option = 1,
		assets = {
			shape = {
				{ state="default", file="bar_shape", base=1 },
			},
		},
	},
			
-- White Chocolate Bar
	bar_shape_white = {
		layerType = kChocolateLayer,
		barType = kBar,
		option = 2,
		assets = {
			shape = {
				{ state="default", file="bar_shape", base=2 },
			},
		},
	},
			
-- Dark Chocolate Infusion	
	infusion_shape_dark = {
		layerType = kChocolateLayer,
		barType = kInfusion,
		option = 0,
		tint = DarkChocTint,
		assets = {
			shape = {
				{ state="default", file="infusion_shape", base=0 },
			},
		},
	},
		
-- Milk Chocolate Infusion
	infusion_shape_milk = {
		layerType = kChocolateLayer,
		barType = kInfusion,
		option = 1,
		assets = {
			shape = {
				{ state="default", file="infusion_shape", base=1 },
			},
		},
	},
	
-- White Chocolate Infusion
	infusion_shape_white = {
		layerType = kChocolateLayer,
		barType = kInfusion,
		option = 2,
		assets = {
			shape = {
				{ state="default", file="infusion_shape", base=2 },
			},
		},
	},

-- Dark Chocolate Inca	
	novelty_shape_dark = {
		layerType = kChocolateLayer,
		barType = kNovelty,
		option = 0,
		tint = DarkChocTint,
		assets = {
			shape = {
				{ state="default", file=novelty.."_shape", base=0 },
			},
		},
	},
	
-- Milk Chocolate Inca
	novelty_shape_milk = {
		layerType = kChocolateLayer,
		barType = kNovelty,
		option = 1,
		assets = {
			shape = {
				{ state="default", file=novelty.."_shape", base=1 },
			},
		},
	},
	
-- White Chocolate Inca
	novelty_shape_white = {
		layerType = kChocolateLayer,
		barType = kNovelty,
		option = 2,
		assets = {
			shape = {
				{ state="default", file=novelty.."_shape", base=2 },
			},
		},
	},
----------------------------------------------------------TOPPINGS
-- 1st Truffle Topping
	truffle_topping_1 = {
		layerType = kToppingLayer,
		barType = kTruffle,
		option = 0,
		assets = {
			topping = {
				{ state="default", file="generic_topping", base=topping1 },
			},
		},
	},
		
-- 2nd Truffle Topping
	truffle_topping_2 = {
		layerType = kToppingLayer,
		barType = kTruffle,
		option = 1,
		assets = {
			topping = {
				{ state="default", file="generic_topping", base=topping2 },
			},
		},
	},
	
-- 3rd Truffle Topping
	truffle_topping_3 = {
		layerType = kToppingLayer,
		barType = kTruffle,
		option = 2,
		assets = {
			topping = {
				{ state="default", file="generic_topping", base=topping3 },
			},
		},
	},
	
-- 1st Bar Topping
	bar_topping_1 = {
		x = 0, y = 7,
		layerType = kToppingLayer,
		barType = kBar,
		option = 0,
		assets = {
			topping = {
				{ state="default", file="generic_topping", base=topping1 },
			},
		},
	},
		
-- 2nd Bar Topping
	bar_topping_2 = {
		x = 0, y = 7,
		layerType = kToppingLayer,
		barType = kBar,
		option = 1,
		assets = {
			topping = {
				{ state="default", file="generic_topping", base=topping2 },
			},
		},
	},
	
-- 3rd Bar Topping
	bar_topping_3 = {
		x = 0, y = 7,
		layerType = kToppingLayer,
		barType = kBar,
		option = 2,
		assets = {
			topping = {
				{ state="default", file="generic_topping", base=topping3 },
			},
		},
	},
	
-- 1st Infusion Topping
	infusion_topping_1 = {
		x = 0, y = 0,
		layerType = kToppingLayer,
		barType = kInfusion,
		option = 0,
		assets = {
			topping = {
				{ state="default", file="generic_topping", base=topping1 },
			},
		},
	},
		
-- 2nd Infusion Topping
	infusion_topping_2 = {
		x = 0, y = 0,
		layerType = kToppingLayer,
		barType = kInfusion,
		option = 1,
		assets = {
			topping = {
				{ state="default", file="generic_topping", base=topping2 },
			},
		},
	},
	
-- 3rd Infusion Topping
	infusion_topping_3 = {
		x = 0, y = 0,
		layerType = kToppingLayer,
		barType = kInfusion,
		option = 2,
		assets = {
			topping = {
				{ state="default", file="generic_topping", base=topping3 },
			},
		},
	},

-- 1st Novelty Topping
	novelty_topping_1 = {
		x = 0, y = 0,
		layerType = kToppingLayer,
		barType = kNovelty,
		option = 0,
		assets = {
			topping = {
				{ state="default", file="generic_topping", base=topping1 },
			},
		},
	},
		
-- 2nd Novelty Topping
	novelty_topping_2 = {
		x = 0, y = 0,
		layerType = kToppingLayer,
		barType = kNovelty,
		option = 1,
		assets = {
			topping = {
				{ state="default", file="generic_topping", base=topping2 },
			},
		},
	},
	
-- 3rd Novelty Topping
	novelty_topping_3 = {
		x = 0, y = 0,
		layerType = kToppingLayer,
		barType = kNovelty,
		option = 2,
		assets = {
			topping = {
				{ state="default", file="generic_topping", base=topping3 },
			},
		},
	},

----------------------------------------------------FILLINGS
-- 1st Truffle Filling
	truffle_filling_1 = {
		layerType = kIngredientLayer,
		barType = kTruffle,
		option = 0,
		assets = {
			default = {
				{ state="default", file="truffle_ingred", base=ingred1 },
			},
		},
	},
	
-- 2nd Truffle Filling
	truffle_filling_2 = {
		layerType = kIngredientLayer,
		barType = kTruffle,
		option = 1,
		assets = {
			default = {
				{ state="default", file="truffle_ingred", base=ingred2 },
			},
		},
	},	
	
-- 3rd Truffle Filling
	truffle_filling_3 = {
		layerType = kIngredientLayer,
		barType = kTruffle,
		option = 2,
		assets = {
			default = {
				{ state="default", file="truffle_ingred", base=ingred3 },
			},
		},
	},
	
-- 1st Bar Filling
	bar_filling_1 = {
		layerType = kIngredientLayer,
		barType = kBar,
		option = 0,
		assets = {
			ingred = {
				{ state="default", file="bar_ingred", base=ingred1 },
			},
		},
	},
	
-- 2nd Bar Filling
	bar_filling_2 = {
		layerType = kIngredientLayer,
		barType = kBar,
		option = 1,
		assets = {
			ingred = {
				{ state="default", file="bar_ingred", base=ingred2 },
			},
		},
	},	
	
-- 3rd Bar Filling
	bar_filling_3 = {
		x = 0, y = 0,
		name = "choc_bar_filling_annatto",
		layerType = kIngredientLayer,
		barType = kBar,
		option = 2,
		assets = {
			ingred = {
				{ state="default", file="bar_ingred", base=ingred3 },
			},
		},
	},
	
-- 1st Novelty Filling
	novelty_filling_1 = {
		layerType = kIngredientLayer,
		barType = kNovelty,
		option = 0,
		assets = {
			ingred = {
				{ state="default", file=novelty.."_ingred", base=ingred1 },
			},
		},
	},
	
-- 2nd Novelty Filling
	novelty_filling_2 = {
		layerType = kIngredientLayer,
		barType = kNovelty,
		option = 1,
		assets = {
			ingred = {
				{ state="default", file=novelty.."_ingred", base=ingred2 },
			},
		},
	},	
	
-- 3rd Novelty Filling
	novelty_filling_3 = {
		layerType = kIngredientLayer,
		barType = kNovelty,
		option = 2,
		assets = {
			ingred = {
				{ state="default", file=novelty.."_ingred", base=ingred3 },
			},
		},
	},
---------------------------------------------------INFUSIONS
-- 1st Infusion
	infusion_raspberry = {
		x = 0, y = 0,
		layerType = kInfusionLayer,
		barType = kInfusion,
		option = 0,
		assets = {
			default = {
				{ state="default", file="infusion_layer", base=infusion1 },
			},
		},
	},
	
-- 2nd Infusion
	infusion_orange = {
		x = 0, y = 0,
		layerType = kInfusionLayer,
		barType = kInfusion,
		option = 1,
		assets = {
			default = {
				{ state="default", file="infusion_layer", base=infusion2 },
			},
		},
	},
	
-- 3rd Infusion
	infusion_caramel = {
		x = 0, y = 0,
		layerType = kInfusionLayer,
		barType = kInfusion,
		option = 2,
		assets = {
			default = {
				{ state="default", file="infusion_layer", base=infusion3 },
			},
		},
	},
}